<?php
session_start();
include '../../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if(isset($_POST['submit'])) {
        // Retrieve form data
        $ename = $_POST['ename'];
        $branch = $_POST['branch'];
        $start_date = $_POST['start_date'];
        $end_date = $_POST['end_date'];
        $notes = $_POST['notes'];

        // Prepare SQL statement
        $stmt = $conn->prepare("INSERT INTO event (ename, branch, start_date, end_date, notes) VALUES (:ename, :branch, :start_date, :end_date, :notes)");

        // Bind parameters
        $stmt->bindParam(':ename', $ename);
        $stmt->bindParam(':branch', $branch);
        $stmt->bindParam(':start_date', $start_date);
        $stmt->bindParam(':end_date', $end_date);
        $stmt->bindParam(':notes', $notes);

        // Execute the statement
        $stmt->execute();
        $_SESSION['success'] = "success";

        header("location:../manage_event.php");
    }





} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>