<?php
session_start();
include '../assets/constant/config.php';

try {
  $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
  $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo "Connection failed: " . $e->getMessage();
}
?>
<?php include('include/sidebar.php'); ?>

<?php include('include/header.php'); ?>

<!--  connect author at mdkhairnar92@gmail.com  -->

<div class="page-content-wrapper ">

  <div class="container-fluid">

    <div class="row">
      <div class="col-sm-12">
        <div class="page-title-box">
          <div class="btn-group float-right">


          </div>
          <h4 class="page-title">OTP</h4>
        </div>
      </div>
      <div class="clearfix"></div>
    </div>
    <!-- end page title end breadcrumb -->
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">

            <div class="tab-content">

              <div class="tab-pane active p-3" id="home" role="tabpanel">
                <form name="myform" action="app/user_crud.php" class="row" method="POST" enctype="multipart/form-data" onsubmit="return validation()" id="add_service">

   <input type="hidden" name="code" value="<?php echo $_GET['otp']; ?>">
 <div class="section-title text-center mb-50">
        <h2>Enter OTP</h2>
      </div>  
                            
<div class="row mt-25">
        
        <div class="form-group position-relative mb-4 d-flex  otp-input-fields">
          <input type="text" id="otp1" name="input1" maxlength="1" class="otp__digit otp__field__1 otp-input form-control mb-2 mr-2" required>
          <input type="text" id="otp2" name="input2" maxlength="1" class="otp__digit otp__field__2 otp-input form-control mb-2 mr-2" required>
          <input type="text" id="otp3" name="input3" maxlength="1" class="otp__digit otp__field__3 otp-input form-control mb-2 mr-2" required>
          <input type="text" id="otp4" name="input4" maxlength="1" class="otp__digit otp__field__4 otp-input form-control mb-2 mr-2" required>
          <input type="text" id="otp5" name="input5" maxlength="1" class="otp__digit otp__field__5 otp-input form-control mb-2 mr-2" required>
          <input type="text" id="otp6" name="input6" maxlength="1" class="otp__digit otp__field__6 otp-input form-control mb-2 mr-2" required>

        </div>

        <div class="col-md-12">

          <div class="form-group text-center mb-0">
            <button type="button" class="theme-btn" id="pasteButton">Paste OTP</button>
            <button type="submit" name="submit" class="theme-btn">Submit <i class="fas fa-arrow-right"></i></button>
          </div>
        </div>
      </div>

                </form>
              </div>


            </div>

          </div>
        </div><!--end card-->
      </div><!--end col-->
    </div><!--end row-->
  </div> <!-- Page content Wrapper -->
</div> <!-- content -->

<?php include('include/footer.php'); ?>
<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->

<script>
  const pasteButton = document.getElementById("pasteButton");
  const otpInputs = document.getElementsByClassName("otp-input");

  // Function to validate input and accept only numeric characters
  function validateInput(input) {
    const regex = /^[0-9]+$/; // Regular expression to match only numeric characters
    return regex.test(input);
  }

  // Event listener for the paste button
  pasteButton.addEventListener("click", function() {
    const clipboardData = navigator.clipboard;

    if (!clipboardData) {
      console.error("Clipboard API not supported in this browser.");
      return;
    }

    clipboardData.readText().then(text => {
      const otp = text.trim();
      if (otp.length === 6 && /^\d+$/.test(otp)) {
        for (let i = 0; i < otp.length; i++) {
          otpInputs[i].value = otp[i];
        }
      } else {
        console.error("Invalid OTP length or format. Expected length: 6, Numeric characters only");
      }
    }).catch(err => {
      console.error("Failed to read clipboard data: ", err);
    });
  });

  // Event listener for input in OTP input fields
  for (let i = 0; i < otpInputs.length; i++) {
    otpInputs[i].addEventListener("input", function(event) {
      const input = event.target.value;
      if (!validateInput(input)) {
        event.target.value = ""; // Clear the input if non-numeric characters are entered
      }
    });
  }
</script>
<script>
    function validation() {
        var fileInput = document.getElementById('add_service').photo1;
        var filePath = fileInput.value;
        var allowedExtensions = /\.(jpg|jpeg|png|docx|pdf)$/i;

        if (!allowedExtensions.test(filePath)) {
            alert('Invalid file type! Please upload a JPG, JPEG, PNG, DOCx, or PDF file.');
            fileInput.value = '';
            return false;
        }
        return true;
    }
</script>
<script>
function addService() {
        jQuery.validator.addMethod("alphanumeric", function(value, element) {
            return this.optional(element) || /^(?=.[a-zA-Z])[a-zA-Z0-9\s!@#$%^&()_-]+$/.test(value);
        }, "Please enter alphanumeric characters only");

        jQuery.validator.addMethod("lettersonly", function(value, element) {
            return this.optional(element) || /^[a-zA-Z\s]*$/.test(value);
        }, "Please enter alphabet characters only");
  
    $('#add_service').validate({
      rules: {
        branch: {
          required: true,
          alphanumeric: true
        },
      incometype: {
          required: true,
          alphanumeric: true
        },
     amount: {
          required: true,
          alphanumeric: true
        },
     date: {
          required: true
        },
        description: {
          required: true
        }
      },
      messages: {
        branch: {
          required: "Please enter the name",
          alphanumeric: "Only alphanumeric characters are allowed"
        },
        description: {
          required: "Please enter the notes"
        }
      }
    });
}
</script>