<?php
session_start();
include '../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>
<?php include('include/sidebar.php'); ?>
<?php include('include/header.php'); ?>

<!--  connect author at mdkhairnar92@gmail.com  -->

<div class="page-content-wrapper ">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">
                    <div class="btn-group float-right"></div>
                    <h4 class="page-title">Add Payment</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active p-3" id="home" role="tabpanel">
                                <form name="myform" action="app/payment_crud.php" class="row" method="POST" enctype="multipart/form-data" onsubmit="return validation()" id="add_service">
                                    <div class="form-group col-md-6">
                                        <label for="id_label_multiple">Member<span class="text-danger">*</span></label>
                                        <select class="form-control select2" aria-label="Default select example" type="text" name="member">
                                            <option value="">Select member</option>
                                            <?php    
                                            $sql1 = $conn->prepare("select * from `member` where delete_status='0'");
                                            $sql1->execute();
                                            $row1 = $sql1->fetchAll();
                                            foreach ($row1 as $key1) { ?>
                                                <option value="<?php echo $key1['name']; ?>"><?php echo $key1['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="control-label">Amount<span class="text-danger">*</span></label>
                                        <input class="form-control" type="number" name="amount">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="control-label">Date<span class="text-danger">*</span></label>
                                        <input class="form-control" type="date" name="date">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="id_label_multiple">Payment Method<span class="text-danger">*</span></label>
                                        <select class="form-control" aria-label="Default select example" name="paymentmethod" id="paymentmethod">
                                            <option value="">Select</option>
                                            <option value="Cash">Cash</option>
                                            <option value="Online Payment">Online Payment</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="control-label">Notes<span class="text-danger">*</span></label>
                                        <textarea class="form-control" type="text" name="notes" placeholder="Enter Notes"></textarea>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <button type="button" class="btn btn-primary" id="rzp-button1" onclick="pay_now()">Pay</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div><!--end card-->
            </div><!--end col-->
        </div><!--end row-->
    </div> <!-- Page content Wrapper -->
</div> <!-- content -->

<?php include('include/footer.php'); ?>
<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->
<!-- <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
<script>
function pay_now() {
    var member = $("select[name='member']").val();
    var amount = $("input[name='amount']").val();
    var date = $("input[name='date']").val();
    var paymentmethod = $("select[name='paymentmethod']").val();
    var notes = $("textarea[name='notes']").val();
    
    if (paymentmethod === "Cash") {
        // Directly process the payment without Razorpay
        $.ajax({
            url: 'process_payment.php',
            method: 'POST',
            data: {
                'payment_id': 'N/A', // No payment id for cash transactions
                'member': member,
                'amount': amount,
                'date': date,
                'paymentmethod': paymentmethod,
                'notes': notes
            },
            success: function(data) {
                var result = JSON.parse(data);
                if (result.status === 'success') {
                    alert('Payment Successful: ' + result.message);
                    location.reload();
                } else {
                    alert('Payment Failed: ' + result.message);
                }
            },
            error: function(error) {
                console.error(error);
            }
        });
    } else if (paymentmethod === "Online Payment") {
        // Process payment through Razorpay
        var actual_amount = amount * 100;

        var options = {
            "key": "rzp_test_D2r1vGHsLrVCXK", // Your Razorpay API Key
            "amount": actual_amount,
            "currency": "INR",
            "name": member,
            "description": notes,
            "handler": function(response) {
                $.ajax({
                    url: 'process_payment.php',
                    method: 'POST',
                    data: {
                        'payment_id': response.razorpay_payment_id,
                        'member': member,
                        'amount': amount,
                        'date': date,
                        'paymentmethod': paymentmethod,
                        'notes': notes
                    },
                    success: function(data) {
                        var result = JSON.parse(data);
                        if (result.status === 'success') {
                            alert('Payment Successful: ' + result.message);
                            location.reload();
                        } else {
                            alert('Payment Failed: ' + result.message);
                        }
                    },
                    error: function(error) {
                        console.error(error);
                    }
                });
            },
            "prefill": {
                "name": member,
                "email": "", // add email if available
                "contact": "" // add contact number if available
            },
            "theme": {
                "color": "#F37254"
            }
        };

        var rzp1 = new Razorpay(options);
        rzp1.open();
    } else {
        alert('Please select a payment method');
    }
}
</script>
<script>
function addService() {
        jQuery.validator.addMethod("alphanumeric", function(value, element) {
            return this.optional(element) || /^(?=.[a-zA-Z])[a-zA-Z0-9\s!@#$%^&()_-]+$/.test(value);
        }, "Please enter alphanumeric characters only");

        jQuery.validator.addMethod("lettersonly", function(value, element) {
            return this.optional(element) || /^[a-zA-Z\s]*$/.test(value);
        }, "Please enter alphabet characters only");
  
    $('#add_service').validate({
      rules: {
        member: {
          required: true,
          alphanumeric: true
        },
         amount: {
          required: true,
          alphanumeric: true
        },
         date: {
          required: true,
          alphanumeric: true
        },
        paymentmethod: {
          required: true,
          alphanumeric: true
        },
        notes: {
          required: true
        }
      },
      messages: {
        amount: {
          required: "Please enter the name"
         
        },
        notes: {
          required: "Please enter the notes"
        }
      }
    });
}
</script>